//
//  UCITask.h
//  UCI Loader
//
//  Created by Ole K. Christensen on 28/12-04.
//  Copyright 2004 Sigma GameWare. All rights reserved.
//

#import <Cocoa/Cocoa.h>


#define kUCIBufMaxLen 100000

@protocol UCITaskController

// Your controller's implementation of this method will be called when output arrives from the NSTask.
// Output will come from both stdout and stderr, per the TaskWrapper implementation.
- (void)appendOutput:(NSString *)output;

// This method is a callback which your controller can use to do other initialization when a process
// is launched.
- (void)processStarted;

// This method is a callback which your controller can use to do other cleanup when a process
// is halted.
- (void)processFinished:(int)taskId;

- (void)sendToSigma:(char *)uciMsg fromTaskId:(int)taskId;   // UCI message from engine to be sent to Sigma GUI

@end


@interface UCITask : NSObject
{
    NSTask 	*task;
    id		<UCITaskController>controller;
    char    uciBuf[kUCIBufMaxLen];
    int     uciBufLen;
    BOOL    taskId;
}

// This is the designated initializer - pass in your controller and any task arguments.
// The first argument should be the path to the executable to launch with the NSTask.
- (id)initWithController:(id <UCITaskController>)controller;

// This method launches the process, setting up asynchronous feedback notifications.
- (void) startProcess:(const char *)enginePath;

// Sends text message to task
- (void) sendMsg:(const char *)uciMsg;

// This method stops the process, stoping asynchronous feedback notifications.
- (void) stopProcess;

// This method sets the background state of the task. If the task is in the background
- (void) setTaskId:(int)taskId;

@end
